---
title: "Introduction à Docker"
course: "docker"
slug: "1-introduction-a-docker"
order: 1
createdAt: 2025-09-24
updatedAt: 2025-09-24
---

## Qu'est-ce que Docker ?

**Docker** est une plateforme open-source qui permet de construire, livrer et exécuter des applications dans des **conteneurs**.

> [!info] Définition: Conteneur Docker
> Un conteneur Docker est une unité légère, portable et auto-suffisante qui contient tout ce dont une application a besoin pour fonctionner (code, librairies, dépendances, etc.).

**Analogie simple** : C'est un peu comme une boîte hermétique - tu y mets ton application et tout ce qu'elle nécessite, et tu peux ensuite la déplacer ou l'exécuter n'importe où, sans te soucier de l'environnement système.

---

## Pourquoi Docker ?

Voici les principaux avantages de Docker :

**Portabilité** : un conteneur fonctionne de la même manière sur tous les environnements (dev, test, prod).

**Isolation** : chaque conteneur tourne de manière indépendante, sans interférer avec les autres.

**Rapidité** : les conteneurs démarrent en quelques secondes (beaucoup plus rapide qu'une VM).

**Reproductibilité** : on peut facilement recréer un environnement à l'identique.

**Légèreté** : les conteneurs utilisent les ressources du système hôte sans embarquer un OS complet (contrairement aux machines virtuelles).

---

## Différence entre Machine Virtuelle et Conteneur

|Critère|Machine Virtuelle|Conteneur Docker|
|---|---|---|
|**Poids**|Lourde (inclut un OS complet)|Léger (partage le noyau de l'hôte)|
|**Démarrage**|Lente (plusieurs minutes)|Rapide (quelques secondes)|
|**Isolation**|Très forte (noyau séparé)|Moins isolé mais suffisant|
|**Utilisation**|Pour séparer complètement les OS|Pour packager des apps portables|
|**Ressources**|Utilise beaucoup de RAM/CPU|Très efficace en ressources|

> [!tip] Conseil pratique
> Utilisez Docker pour packager vos applications et leurs dépendances, et les machines virtuelles pour isoler complètement différents systèmes d'exploitation.

---

## Cas d'usage typiques de Docker

- **Déployer une app web** (Node.js, Python, etc.) avec ses dépendances
- **Créer un environnement de développement local** reproductible
- **Tester différentes versions** de langages ou frameworks
- **Automatiser les déploiements** CI/CD
- **Exécuter des bases de données ou outils** en local sans les installer

---

## Liens vers la partie suivante

- [[2. Concepts de base de Docker]]

---

## Tags

#docker #conteneurisation #devops #débutant #introduction